(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5266,        136]*)
(*NotebookOutlinePosition[      5965,        160]*)
(*  CellTagsIndexPosition[      5921,        156]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Ejercicio 1", "Exercise"],

Cell[TextData[{
  "a) Usa los comandos \"Table[ ]\" y \"Random[ ]\" para generar una lista, \
que llamar\[AAcute]s \"lista100\", con 100 n\[UAcute]meros aleatorios \
comprendidos entre 0 y 1. Utiliza la asignaci\[OAcute]n diferida para que la \
lista sea distinta cada vez que la llamas. \nb) Usa los comando \"Table[ ]\", \
\"Length[ ]\" y \"Select[ ]\" para obtener una tabla, que llamar\[AAcute]s \
\"clasifica100\", con el n\[UAcute]mero de elementos que hay en \"lista100\" \
comprendidos en cada uno de los intervalos",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \([\((k - 1)\)/10, k/\(10[\)\)\)\)]],
  " para k=1,2,...,10. \nc) Dividiendo num\[EAcute]ricamente (es decir, no \
trabajes con valores exactos, usa el comando N[ ]) por 100 los \
n\[UAcute]meros obtenidos en el apartado anterior obtendr\[AAcute]s una tabla \
a la que llamar\[AAcute]s \"frecuencias100\". \nd) Convierte \"lista100\", \
\"clasifica100\" y \"frecuencias100\" en funciones \"lista[q_]\", \
\"clasifica[q_]\", \"frecuencias[q_]\" que hagan lo mismo que antes pero con \
q n\[UAcute]meros aleatorios. Calcula \"frecuencias[q]\" para q variando \
desde 100 hasta 1100 de 200 en 200. Observa c\[OAcute]mo las frecuencias se \
aproximan cada vez m\[AAcute]s al valor 0.1."
}], "ExerciseText"],

Cell[BoxData[{
    \(\(lista[q_] := Table[Random[], {q}];\)\), "\n", 
    \(\(\(comprendidoentre[k_]\)[x_] := \((k - 1)\)/10 \[LessEqual] x < 
          k/10;\)\), "\n", 
    \(clasifica[
        q_] := {temp = lista[q]; 
          Table[Length[Select[temp, comprendidoentre[k]]], {k, 1, 
              10}]}[\([1]\)]\), "\n", 
    \(frecuencias[q_] := N[clasifica[q]/q]\), "\n", 
    \(Table[frecuencias[q], {q, 100, 1100, 200}]\), "\[IndentingNewLine]", 
    \(\(Clear[temp];\)\)}], "Input"],

Cell[BoxData[
    \(Apply[Plus, %%, {1}]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  "Define ",
  Cell[BoxData[
      \(TraditionalForm\`listauno = Range[2, 21], \ 
      listados = Range[22, 31]\)]],
  ". Realiza las siguientes operaciones usando algunos de los comandos antes \
vistos.\na) Multiplica cada elemento de \"listauno\" por todos los elementos \
de \"listados\". El resultado ser\[AAcute] una lista con 20 elementos (que a \
su vez ser\[AAcute]n listas de 10 elementos), a la que llamar\[AAcute]s \
\"productos\".\nb) Calcula la suma de cada una de las listas que forman la \
lista \"productos\" (no te equivoques, comprueba el resultado). Obtendr\
\[AAcute]s una lista con 20 n\[UAcute]meros.\nc) Calcula el producto de los \
elementos de la lista obtenida en el apartado anterior."
}], "ExerciseText"],

Cell[BoxData[{
    \(listauno = Range[2, 21]; \nlistados = Range[22, 31]; \n
    productos = Outer[Times, listauno, listados]\), 
    \(Apply[Plus, Transpose[productos]]\), 
    \(Apply[Times, %]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell["\<\
a) Genera una lista de 30 elementos cuyos elementos sean listas de dos n\
\[UAcute]meros que no sean valores exactos.
b) Usando una regla de sustituci\[OAcute]n apropiada transforma la lista \
anterior en otra en la cual la primera coordenada de cada lista de dos \
elementos se ha multiplicado por 3 y la segunda coordenada se ha elevado al \
cuadrado.\
\>", "ExerciseText"],

Cell[BoxData[{
    \(lista = Table[{Sin[x], Cos[x]}, {x, 1. , 30}]\), 
    \(lista /. {x_, y_} -> {3  x, y\^2}\)}], "Input"]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{994, 611},
WindowMargins->{{2, Automatic}, {Automatic, 2}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 31, 0, 68, "Exercise"],
Cell[1810, 55, 1273, 19, 299, "ExerciseText"],
Cell[3086, 76, 493, 10, 276, "Input"],
Cell[3582, 88, 53, 1, 94, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3672, 94, 31, 0, 68, "Exercise"],
Cell[3706, 96, 749, 13, 221, "ExerciseText"],
Cell[4458, 111, 209, 4, 176, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4704, 120, 31, 0, 68, "Exercise"],
Cell[4738, 122, 385, 7, 101, "ExerciseText"],
Cell[5126, 131, 124, 2, 98, "Input"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

